package demo.common;
import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;

import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.JFrame;

import demo.module.LoginModule;
import netsdk.lib.CommonFunctions;
import netsdk.lib.ToolKits;
import javax.swing.JRadioButton;
import java.awt.event.ActionEvent;
import javax.swing.BoxLayout;
import java.awt.GridBagLayout;


public class P2PLoginPanel extends JPanel implements ItemListener{
	private JTextField tf_server;
	private JTextField tf_userName;
	private JPasswordField tf_password;
	private JTextField tf_port;
	private JTextField tf_sn;
	private JRadioButton rdb_P2P;
	private JRadioButton rdb_P2P2;
	private ButtonGroup group;
	private JLabel lbl_res;
	private JRadioButton rdb_TCP;
	private JButton btn_login;
	private JButton btn_cancel;
	private JLabel lblNewLabel;
	public P2PLoginPanel() {
		setSize(407, 264);
		setLayout(null);
		
		lblNewLabel = new JLabel("P2P Server");
		lblNewLabel.setBounds(27, 87, 69, 15);
		add(lblNewLabel);
		
		tf_server = new JTextField();
		tf_server.setText("c2020.autonat.com");
		tf_server.setBounds(106, 81, 108, 21);
		add(tf_server);
		tf_server.setColumns(10);
		
		JLabel lblNewLabel_1 = new JLabel("UserName");
		lblNewLabel_1.setBounds(27, 26, 54, 15);
		add(lblNewLabel_1);
		
		tf_userName = new JTextField();
		tf_userName.setText("admin");
		tf_userName.setBounds(106, 20, 108, 21);
		add(tf_userName);
		tf_userName.setColumns(10);
		
		JLabel lblNewLabel_2 = new JLabel("Password");
		lblNewLabel_2.setBounds(27, 54, 54, 15);
		add(lblNewLabel_2);
		
		tf_password = new JPasswordField();
		tf_password.setBounds(106, 50, 108, 21);
		add(tf_password);
		tf_password.setColumns(10);
		
		JLabel lblNewLabel_3 = new JLabel("Port");
		lblNewLabel_3.setBounds(27, 118, 54, 15);
		add(lblNewLabel_3);
		
		tf_port = new JTextField();
		tf_port.setText("7968");
		tf_port.setBounds(106, 112, 108, 21);
		add(tf_port);
		tf_port.setColumns(10);
		
		JLabel lblNewLabel_4 = new JLabel("SN");
		lblNewLabel_4.setBounds(27, 150, 54, 15);
		add(lblNewLabel_4);
		
		tf_sn = new JTextField();
		tf_sn.setText("N8EAD137G506");
		tf_sn.setBounds(106, 144, 108, 21);
		add(tf_sn);
		tf_sn.setColumns(10);
		
		rdb_TCP = new JRadioButton("TCP");
		rdb_TCP.setBounds(26, 182, 54, 23);
		
		
		rdb_P2P = new JRadioButton("P2P");
		rdb_P2P.setBounds(84, 182, 59, 23);
				
		rdb_P2P2 = new JRadioButton("P2P 2.0");
		rdb_P2P2.setSelected(true);
		rdb_P2P2.setBounds(145, 182, 69, 23);
		
		rdb_TCP.addItemListener(this);
		rdb_P2P.addItemListener(this);
		rdb_P2P2.addItemListener(this);
		
		group = new ButtonGroup();
		group.add(rdb_TCP);
		group.add(rdb_P2P);
		group.add(rdb_P2P2);
		
		add(rdb_TCP);
		add(rdb_P2P);
		add(rdb_P2P2);
		
		btn_login = new JButton("Login");
		btn_login.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent arg0) {
				String userName = tf_userName.getText();
				String psw = tf_password.getText();
				String server = tf_server.getText();
				int port = Integer.parseInt(tf_port.getText()) ;
				String sn = tf_sn.getText();
				if(rdb_P2P2.isSelected()) {
					LoginModule.netsdk.NET_SDK_SetNat2Addr(server,(short)port);
				}
				if(rdb_TCP.isSelected()) {
					if(LoginModule.login(server, port, userName, psw)) {
						String product = CommonFunctions.ByteToStr(LoginModule.m_stDeviceInfo.deviceProduct,"UTF8");
						lbl_res.setText(product);
					}
				}
				else {
					if(LoginModule.loginEx(server, port, sn, userName, psw)) {
						String product = CommonFunctions.ByteToStr(LoginModule.m_stDeviceInfo.deviceProduct,"UTF8");
						lbl_res.setText(product);
					}
				}
				
								
			}
		});
		btn_login.setBounds(26, 220, 93, 23);
		add(btn_login);
		
		btn_cancel = new JButton("Cancel");
		btn_cancel.setBounds(129, 220, 93, 23);
		add(btn_cancel);
		
		lbl_res = new JLabel("");
		lbl_res.setBounds(247, 24, 121, 219);
		add(lbl_res);
		
		
	}
	public void addCancelBtnActionListener(ActionListener e) {
		btn_cancel.addActionListener(e);
	}
	@Override
	public void itemStateChanged(ItemEvent arg0) {
		// TODO Auto-generated method stub
		if(arg0.getSource() == rdb_TCP) {
			lblNewLabel.setText("IP");
			tf_sn.setEditable(false);
		}
		else {
			lblNewLabel.setText("P2P Server");
			tf_sn.setEditable(true);
		}
			
	}
}

